/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.DNSAndIPAddrListBoxesInterface;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.HashSet;
import java.util.Iterator;

public class ModifyCertBean
extends PanelBean
implements CertMgtConstants,
DNSAndIPAddrListBoxesInterface {
    private static final String TRACE_MASKD = "XCRTMODD";
    private static final String TRACE_MASKF = "XCRTMODF";
    private static final String TRACE_MASKT = "XCRTMODT";
    private ServerCert certificate = null;
    private String m_sDNSEntry;
    private String m_sDNSListBox;
    private ValueDescriptor[] m_vdDNSListBox;
    private String m_sIPAddrNetworkByte0;
    private String m_sIPAddrNetworkByte1;
    private String m_sIPAddrNetworkByte2;
    private String m_sIPAddrNetworkByte3;
    private String m_sIPAddrListBox;
    private ValueDescriptor[] m_vdIPAddrListBox;

    public ModifyCertBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ModifyCertBean(" + certificate + ", " + ", " + name + ")");
    }

    public void setDNSEntry(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setDNSEntry(" + s + ")");
        this.m_sDNSEntry = s;
    }

    public String getDNSEntry() {
        Trace.trace(TRACE_MASKT, "<->getDNSEntry() returning " + this.m_sDNSEntry);
        return this.m_sDNSEntry;
    }

    public ValueDescriptor[] getDNSListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBoxList() returning " + this.m_vdDNSListBox);
        return this.m_vdDNSListBox;
    }

    public void setDNSListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setDNSListBoxList(" + values + ")");
        this.m_vdDNSListBox = values;
    }

    public void setDNSListBox(String s) {
        Trace.trace(TRACE_MASKT, "<->setDNSListBox(" + s + ")");
        this.m_sDNSListBox = s;
    }

    public String getDNSListBox() {
        Trace.trace(TRACE_MASKT, "<->getDNSListBox() returning " + this.m_sDNSListBox);
        return this.m_sDNSListBox;
    }

    public void setIPAddrNetworkByte0(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte0(" + s + ")");
        this.m_sIPAddrNetworkByte0 = s;
    }

    public String getIPAddrNetworkByte0() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte0() returning " + this.m_sIPAddrNetworkByte0);
        return this.m_sIPAddrNetworkByte0;
    }

    public void setIPAddrNetworkByte1(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte1(" + s + ")");
        this.m_sIPAddrNetworkByte1 = s;
    }

    public String getIPAddrNetworkByte1() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte1() returning " + this.m_sIPAddrNetworkByte1);
        return this.m_sIPAddrNetworkByte1;
    }

    public void setIPAddrNetworkByte2(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte2(" + s + ")");
        this.m_sIPAddrNetworkByte2 = s;
    }

    public String getIPAddrNetworkByte2() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte2() returning " + this.m_sIPAddrNetworkByte2);
        return this.m_sIPAddrNetworkByte2;
    }

    public void setIPAddrNetworkByte3(String s) throws IllegalUserDataException {
        boolean valueToSet = false;
        Trace.trace(TRACE_MASKT, "<->setIPAddrNetworkByte3(" + s + ")");
        this.m_sIPAddrNetworkByte3 = s;
    }

    public String getIPAddrNetworkByte3() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrNetworkByte3() returning " + this.m_sIPAddrNetworkByte3);
        return this.m_sIPAddrNetworkByte3;
    }

    public ValueDescriptor[] getIPAddrListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBoxList() returning " + this.m_vdIPAddrListBox);
        return this.m_vdIPAddrListBox;
    }

    public void setIPAddrListBoxList(ValueDescriptor[] values) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBoxList(" + values + ")");
        this.m_vdIPAddrListBox = values;
    }

    public void setIPAddrListBox(String s) {
        Trace.trace(TRACE_MASKT, "<->setIPAddrListBox(" + s + ")");
        this.m_sIPAddrListBox = s;
    }

    public String getIPAddrListBox() {
        Trace.trace(TRACE_MASKT, "<->getIPAddrListBox() returning " + this.m_sIPAddrListBox);
        return this.m_sIPAddrListBox;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "->load()");
        this.m_sDNSEntry = "";
        this.m_sDNSListBox = "";
        this.m_vdDNSListBox = new ValueDescriptor[0];
        this.m_sIPAddrNetworkByte0 = "";
        this.m_sIPAddrNetworkByte1 = "";
        this.m_sIPAddrNetworkByte2 = "";
        this.m_sIPAddrNetworkByte3 = "";
        this.m_sIPAddrListBox = "";
        this.m_vdIPAddrListBox = new ValueDescriptor[0];
        this.initializeListBoxes();
        Trace.trace(TRACE_MASKT, "->load()");
    }

    public void save() {
    }

    private void initializeListBoxes() {
        ValueDescriptor[] listBox = null;
        Trace.trace(TRACE_MASKT, "->initializeListBoxes()");
        try {
            listBox = this.createListBox(this.getAltDNSNames(), "DNSListBox");
            if (listBox != null) {
                this.m_vdDNSListBox = listBox;
            }
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 11, e).log();
        }
        try {
            listBox = this.createListBox(this.getAltIPAddresses(), "IPAddrListBox");
            if (listBox != null) {
                this.m_vdIPAddrListBox = listBox;
            }
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 11, e).log();
        }
        Trace.trace(TRACE_MASKT, "<-initializeListBoxes()");
    }

    private ValueDescriptor[] createListBox(HashSet elements, String name) {
        int numOfElements = 0;
        ValueDescriptor[] result = null;
        int index = 0;
        if (elements != null && (numOfElements = elements.size()) > 0) {
            result = new ValueDescriptor[numOfElements];
            index = 0;
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                result[index++] = CertMgtPanelUtils.createValueDescriptor(name, (String)i.next());
            }
        }
        return result;
    }

    private HashSet getAltDNSNames() throws HException {
        HashSet altNames = null;
        if (this.certificate != null) {
            altNames = this.certificate.getSubjectAltNames().getDNSNames();
        }
        if (altNames != null && altNames.size() > 0) {
            return altNames;
        }
        return null;
    }

    private HashSet getAltIPAddresses() throws HException {
        HashSet altNames = null;
        if (this.certificate != null) {
            altNames = this.certificate.getSubjectAltNames().getIPAddrNames();
        }
        if (altNames != null && altNames.size() > 0) {
            return altNames;
        }
        return null;
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (actionCommand.equals("AddDNSButton") || actionCommand.equals("AddIPAddrButton") || actionCommand.equals("RemoveDNSButton") || actionCommand.equals("RemoveIPAddrButton")) {
                CertMgtPanelUtils.handleDNSAndIPAddrListBoxes(actionCommand, elementName, utm, this, this.getMountPrefix(), this.certificate);
            } else if (elementName.equals("SubjectAltNamesOKButton")) {
                CertMgtPanelUtils.sendTaskletRequest("finishModSubjectAltNames", CertMgtPanelUtils.getSubjectAltNames(this.getDNSListBoxList(), this.getIPAddrListBoxList()), null, this.certificate, this);
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }

    public PanelBean getPanelBean() {
        return this;
    }
}

